<?php session_start(); 
if (!isset($_SESSION["user"])) { 
    header("location: login"); 
    die(); 
} 

$host = "localhost"; 
$user = "appshett_ibill"; 
$pass = "appshett_ibill"; 
$dbname = "appshett_ibill"; 
$conn = new mysqli($host, $user, $pass, $dbname); 

if ($conn->connect_error) { 
    die("Connection failed: " . $conn->connect_error); 
} 

$sql = "SELECT tracking_id, slip_type, id_number, consent, created_at, status, countdown, timestamp, response FROM validation_request ORDER BY created_at DESC"; 
$result = $conn->query($sql); 

$page = "VIEW_TIN_VERIFICATON"; 
$site_title = "SHETTY VERIFY"; 
$email = $_SESSION["user"]; 
$user = getUserDetails($email); 

function getUserDetails($email) { 
    global $conn; 
    $sql = "SELECT firstName, lastName, email FROM users WHERE email = ?"; 
    $stmt = $conn->prepare($sql); 
    $stmt->bind_param("s", $email); 
    $stmt->execute(); 
    $result = $stmt->get_result(); 
    return $result->fetch_assoc(); 
} 
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title><?= $site_title ?> - View TIN Verification Requests</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
</head>
<body>
    <div class="container mt-4">
        <h2 class="text-center">Welcome to <?= $site_title ?>, <?= htmlspecialchars($user["firstName"]); ?>!</h2>
        <div class="card">
            <div class="card-header">TIN Verification Request History</div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-striped table-bordered table-hover">
                        <thead class="table-dark">
                            <tr>
                                <th>Tracking ID</th>
                                <th>Slip Type</th>
                                <th>ID Number</th>
                                <th>Consent</th>
                                <th>Created At</th>
                                <th>Status</th>
                                <th>Countdown</th>
                                <th>Timestamp</th>
                                <th>Response</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php if ($result->num_rows > 0) { 
                                while ($row = $result->fetch_assoc()) { ?>
                                    <tr>
                                        <td><?= htmlspecialchars($row['tracking_id']) ?></td>
                                        <td><?= htmlspecialchars($row['slip_type']) ?></td>
                                        <td><?= htmlspecialchars($row['id_number']) ?></td>
                                        <td><?= ($row['consent'] ? 'Yes' : 'No') ?></td>
                                        <td><?= htmlspecialchars($row['created_at']) ?></td>
                                        <td><?= htmlspecialchars($row['status']) ?></td>
                                        <td><?= htmlspecialchars($row['countdown']) ?></td>
                                        <td><?= htmlspecialchars($row['timestamp']) ?></td>
                                        <td><?= htmlspecialchars($row['response']) ?></td>
                                        <td>
                                            <form action="update_status.php" method="POST">
                                                <input type="hidden" name="tracking_id" value="<?= htmlspecialchars($row['tracking_id']) ?>">
                                                <select name="status" class="form-select form-select-sm" required>
                                                    <option value="Approved">Approve</option>
                                                    <option value="Rejected">Reject</option>
                                                    <option value="Processing">Processing</option>
                                                    <option value="Pending">Pending</option>
                                                </select>
                                                <button type="submit" class="btn btn-success btn-sm mt-2">Submit</button>
                                            </form>
                                        </td>
                                    </tr>
                            <?php } } else { ?>
                                <tr>
                                    <td colspan="10" class="text-center">No TIN Verification requests found.</td>
                                </tr>
                            <?php } ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</body>
</html>


    <footer class="text-center mt-4">
        <p>© <script>document.write(new Date().getFullYear())</script>
      , All Rights Reserved Developed By <a href="https://chat.whatsapp.com/IVeuVW5SKXN7vnI23nXclJ">M SHETTY</a>
    </footer>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>

<?php $conn->close(); ?>


