<?php
session_start();
include "ajax/konnection.php";
include "ajax/func.php";

if (!isset($_SESSION["user"])) {
  header("location: login");
  die();
}

$email  = $_SESSION["user"];
$bal = getBal($email);
$user = getUserDetails($email);
$verifs = 0;
$charges = getCharges();
$page  = "VIEW_TIN_VERIFICATION";
?>
<!DOCTYPE html>

<html lang="en" class="light-style layout-compact layout-navbar-fixed layout-menu-fixed     " dir="ltr" data-theme="theme-default" data-assets-path="/assets" data-base-url="/assets/" data-framework="html" data-template="vertical-menu-theme-default-light">


<meta http-equiv="content-type" content="text/html;charset=UTF-8" />

<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0" />

  <title><?= $site_title;?> Dashboard</title>
  <meta name="description" content="" />
  <meta name="keywords" content="">
  <link rel="icon" type="image/x-icon" href="favicon.ico" />
  <link rel="preconnect" href="https://fonts.googleapis.com/">
  <link rel="preconnect" href="https://fonts.gstatic.com/" crossorigin>
  <link href="https://fonts.googleapis.com/css2?family=Public+Sans:ital,wght@0,300;0,400;0,500;0,600;0,700;1,300;1,400;1,500;1,600;1,700&amp;display=swap" rel="stylesheet">

  <link rel="stylesheet" href="assets/vendor/fonts/boxiconsc4a7.css?id=87122b3a3900320673311cebdeb618da" />
  <link rel="stylesheet" href="assets/vendor/fonts/fontawesome8a69.css?id=a2997cb6a1c98cc3c85f4c99cdea95b5" />
  <link rel="stylesheet" href="assets/vendor/fonts/flag-icons80a8.css?id=121bcc3078c6c2f608037fb9ca8bce8d" />
  <!-- Core CSS -->
  <link rel="stylesheet" href="assets/vendor/css/rtl/corea8ac.css?id=55b2a9dfaa009c41df62ca8d16e913a8" class="template-customizer-core-css" />
  <link rel="stylesheet" href="assets/vendor/css/rtl/theme-default4c4b.css?id=9182924a7b965439eca5e189ba43eba1" class="template-customizer-theme-css" />
  <link rel="stylesheet" href="assets/css/demob77a.css?id=69dfc5e48fce5a4ff55ff7b593cdf93d" />
  <!-- Vendors CSS -->
  <link rel="stylesheet" href="assets/vendor/libs/perfect-scrollbar/perfect-scrollbare482.css?id=73d641bb8db2475ecafc6c68461ed01b" />
  <link rel="stylesheet" href="assets/vendor/libs/typeahead-js/typeahead05d2.css?id=de339ead5e9c9e36f12e46cbef7aaffd" />

  <!-- Vendor Styles -->
  <link rel="stylesheet" href="assets/vendor/libs/apex-charts/apex-charts.css">

  <link rel="stylesheet" href="assets/vendor/libs/toastr/toastr.css" />
  <link rel="stylesheet" href="assets/vendor/libs/animate-css/animate.css" />

  <!-- Page Styles -->

  <!-- Include Scripts for customizer, helper, analytics, config -->
  <!-- $isFront is used to append the front layout scriptsIncludes only on the front layout otherwise the variable will be blank -->
  <!-- laravel style -->
  <script src="assets/vendor/js/helpers.js"></script>
  <!-- beautify ignore:start -->
  <!--! Template customizer & Theme config files MUST be included after core stylesheets and helpers.js in the <head> section -->
  <!--? Template customizer: To hide customizer set displayCustomizer value false in config.js.  -->
  <script src="assets/vendor/js/template-customizer.js"></script>

  <!--? Config:  Mandatory theme config file contain global vars & default theme options, Set your preferred theme option in this file.  -->
  <script src="assets/js/config.js"></script>

  <script>
    window.templateCustomizer = new TemplateCustomizer({
      cssPath: '',
      themesPath: '',
      defaultStyle: "light",
      defaultShowDropdownOnHover: "true", // true/false (for horizontal layout only)
      displayCustomizer: "true",
      lang: 'en',
      pathResolver: function(path) {
        var resolvedPaths = {
          // Core stylesheets
                      'core.css': '/assets/vendor/css/rtl/core.css?id=55b2a9dfaa009c41df62ca8d16e913a8',
            'core-dark.css': '/assets/vendor/css/rtl/core-dark.css?id=d98ae2a03b5b1b05651411ee58ef81a6',
          
          // Themes
                      'theme-default.css': '/assets/vendor/css/rtl/theme-default.css?id=9182924a7b965439eca5e189ba43eba1',
            'theme-default-dark.css':
            '/assets/vendor/css/rtl/theme-default-dark.css?id=ae30991ef3f62e7c03ca6f8930843e80',
                      'theme-bordered.css': '/assets/vendor/css/rtl/theme-bordered.css?id=a4f95a927b1e2bcdfd57a3bbfb2bd3d9',
            'theme-bordered-dark.css':
            '/assets/vendor/css/rtl/theme-bordered-dark.css?id=2a668deb480284f975db82d0a7277156',
                      'theme-semi-dark.css': '/assets/vendor/css/rtl/theme-semi-dark.css?id=9c02fb39c47f91b2d198f343fa8b4df7',
            'theme-semi-dark-dark.css':
            '/assets/vendor/css/rtl/theme-semi-dark-dark.css?id=c4b1950a14ffd431f752917b97a0ee51',
                  }
        return resolvedPaths[path] || path;
      },
      'controls': ["rtl","style","headerType","contentLayout","layoutCollapsed","layoutNavbarOptions","themes"],
    });
  </script>
</head>

<body>
  
   

  <!-- Layout Content -->
  <div class="layout-wrapper layout-content-navbar ">
  <div class="layout-container">

       <?php include "includes/aside.php"; ?>

    <!-- Layout page -->
    <div class="layout-page">

      
      

      <!-- BEGIN: Navbar-->
            <!-- Navbar -->
    <?php include "includes/navbar.php"; ?>
  <!-- / Navbar -->
            <!-- END: Navbar-->


      <!-- Content wrapper -->
      <div class="content-wrapper">

        <!-- Content -->
                  <div class="container-xxl flex-grow-1 container-p-y">
            <h5>Welcome to <?= $site_title;?>, <?php echo $user["firstName"]; ?>!</h5>
           <div class="col-12">
    <div class="card">
      <h6 class="card-header" >TIN VERIFICATION</h6>
      <div class="card-body">

        <form class="row g-3 fv-plugins-bootstrap5 fv-plugins-framework" novalidate="novalidate">



                            <div class="card">
                                <h5 class="card-header"> <b>NOTE:</b> This Service takes a total of (1-3) Days to get VERIFIED,</h5>
                                <div class="card-body">

                                    <div class="col-md-6">
                                        <div class="mb-3">
                                            <label for="enrollment-type" class="form-label">Select TIN VERIFICATION Type</label>
                                            <select id="enrollment-type" class="form-control" required>
                                                <option value="">-- Select an option --</option>
                                                <option value="RC/BN">RC/BN @ ₦2000.00</option>
                                                <option value="TIN">TIN @ ₦1500.00</option>
                                                <option value="phone">Phone @ ₦1000.00</option>
                                            </select>
                                        </div>

                                        <div class="mb-3">
                                            <label class="form-label">Surname</label>
                                            <input type="text" id="last-name" class="form-control" placeholder="Surname" required>
                                        </div>

                                        <div class="mb-3">
                                            <label class="form-label">Frist Name</label>
                                            <input type="text" id="frist-name" class="form-control" placeholder="Frist Name" required>
                                        </div>

                                        <div class="mb-3">
                                            <label class="form-label">Middle</label>
                                            <input type="text" id="middle" class="form-control" placeholder="middle name" option>
                                        </div>

                                        <div class="mb-3">
                                            <label class="form-label">State of Origin</label>
                                            <input type="text" id="state-origin" class="form-control" placeholder="State of Origin" required>
                                        </div>

                                        <div class="mb-3">
                                            <label class="form-label">Address</label>
                                            <input type="text" id="area-residence" class="form-control" placeholder="Enter address" required>
                                        </div>

                                        <div class="mb-3">
                                            <label class="form-label">Phone Number</label>
                                            <input type="tel" id="phone-number" class="form-control" placeholder="Phone Number" required>
                                        </div>

                                        <div class="mb-3">
                                            <label class="form-label">ID Number</label>
                                            <input type="text" id="area-residence" class="form-control" placeholder="Enter RC/BN OR TIN Number" required>
                                        </div>

                                        <div class="mb-3">
                                            <label class="form-label">Certificate</label>
                                            <input type="file" id="picture" class="form-control" accept="image/*" required>
                                        </div>

                                        <button type="button" class="btn btn-primary w-100 rounded-2" onclick="submitForm()">Submit</button>
                                    </div>


                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- / Content -->

                    <!-- Footer -->
                    <!-- Footer-->
                    <footer class="content-footer footer bg-footer-theme">
                        <div class="container-xxl d-flex flex-wrap justify-content-between py-2 flex-md-row flex-column">
                            <div class="mb-2 mb-md-0">
                                 © <script>document.write(new Date().getFullYear())</script>
      , All Rights Reserved Developed By <a href="https://wa.me/2349064699773">M SHETTY</a>
    </div>

                        </div>
                    </footer>
                    <!--/ Footer-->
                    <!-- / Footer -->
                    <div class="content-backdrop fade"></div>
                </div>
                <!--/ Content wrapper -->
            </div>
            <!-- / Layout page -->
        </div>

        <!-- Overlay -->
        <div class="layout-overlay layout-menu-toggle"></div>
        <!-- Drag Target Area To SlideIn Menu On Small Screens -->
        <div class="drag-target"></div>
    </div>
    <!-- / Layout wrapper -->
    <!--/ Layout Content -->



    <!-- Include Scripts -->
    <!-- $isFront is used to append the front layout scripts only on the front layout otherwise the variable will be blank -->
    <!-- BEGIN: Vendor JS-->
    <script src="assets/vendor/libs/jquery/jquery1e84.js?id=0f7eb1f3a93e3e19e8505fd8c175925a"></script>
    <script src="assets/vendor/libs/popper/popper0a73.js?id=baf82d96b7771efbcc05c3b77135d24c"></script>
    <script src="assets/vendor/js/bootstrapcfc4.js?id=4648227467e3fd3f4cf976cfb0e43aea"></script>
    <script src="assets/vendor/libs/perfect-scrollbar/perfect-scrollbar6188.js?id=44b8e955848dc0c56597c09f6aebf89a"></script>
    <script src="assets/vendor/libs/hammer/hammer2de0.js?id=0a520e103384b609e3c9eb3b732d1be8"></script>
    <script src="assets/vendor/libs/typeahead-js/typeahead60e7.js?id=f6bda588c16867a6cc4158cb4ed37ec6"></script>
    <script src="assets/vendor/js/menu2dc9.js?id=c6ce30ded4234d0c4ca0fb5f2a2990d8"></script>
    <script src="assets/vendor/libs/apex-charts/apexcharts.js"></script>
    <!-- END: Page Vendor JS-->
    <!-- BEGIN: Theme JS-->
    <script src="assets/js/maind63d.js?id=6bea3f2e092d5fe7327c226f3242f31b"></script>

    <!-- END: Theme JS-->
    <!-- Pricing Modal JS-->
    <!-- END: Pricing Modal JS-->
    <!-- BEGIN: Page JS-->
    <script src="assets/js/dashboards-analytics.js"></script>
    <!-- END: Page JS-->
    <script src="assets/vendor/libs/toastr/toastr.js"></script>
    <script src="js/misc.js"></script>
    <!-- END: Page JS-->

</body>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
    function submitForm() {
        // Validate form fields
        const enrollmentType = document.getElementById("enrollment-type").value;
        const firstName = document.getElementById("first-name").value.trim();
        const lastName = document.getElementById("last-name").value.trim();
        const dob = document.getElementById("dob").value;
        const stateOrigin = document.getElementById("state-origin").value.trim();
        const lgaOrigin = document.getElementById("lga-origin").value.trim();
        const areaResidence = document.getElementById("area-residence").value.trim();
        const phoneNumber = document.getElementById("phone-number").value.trim();
        const gender = document.getElementById("gender").value;
        const middle = document.getElementById("middle").value;
        const height = document.getElementById("height").value.trim();
        const picture = document.getElementById("picture").files[0];

        if (!enrollmentType || !firstName || !lastName || !dob || !stateOrigin || !lgaOrigin || !areaResidence || !phoneNumber || !gender || !height || !picture) {
            Swal.fire({
                icon: "error",
                title: "Validation Error",
                text: "Please fill in all the required fields.",
            });
            return;
        }

        if (!/^\d+$/.test(phoneNumber)) {
            Swal.fire({
                icon: "error",
                title: "Validation Error",
                text: "Please enter a valid phone number (digits only).",
            });
            return;
        }

        // Prepare form data
        const formData = new FormData();
        formData.append("enrollmentType", enrollmentType);
        formData.append("firstName", firstName);
        formData.append("lastName", lastName);
        formData.append("dob", dob);
        formData.append("stateOrigin", stateOrigin);
        formData.append("lgaOrigin", lgaOrigin);
        formData.append("areaResidence", areaResidence);
        formData.append("phoneNumber", phoneNumber);
        formData.append("gender", gender);
        formData.append("middle", middle);
        formData.append("height", height);
        formData.append("picture", picture);

        // AJAX request
        fetch("ajax/enroll_pros.php", {
                method: "POST",
                body: formData,
            })
            .then((response) => response.json())
            .then((data) => {
                if (data.success) {
                    Swal.fire({
                        icon: "success",
                        title: "Success",
                        text: data.message,
                    }).then((result) => {
                        if (result.isConfirmed) {
                            window.location.href = 'view_tin_verification.php';
                        }
                    });
                } else {
                    Swal.fire({
                        icon: "error",
                        title: "Submission Failed",
                        text: data.message || "An error occurred while submitting the form.",
                    });
                }
            })
            .catch((error) => {
                console.error("Error:", error);
                Swal.fire({
                    icon: "error",
                    title: "Server Error",
                    text: "An error occurred while submitting the form. Please try again.",
                });
            });
    }
</script>

</html>
